/*
 * Decompiled with CFR 0.152.
 */
package WebseitenPfadGenerator;

import WebseitenPfadGenerator.FileNode;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FileScanner {
    public List<String> scanDirectory(File directory) {
        ArrayList<String> paths = new ArrayList<String>();
        if (!directory.isDirectory() || !directory.exists()) {
            return paths;
        }
        File[] files = directory.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                paths.add(file.getAbsolutePath());
                if (file.isDirectory()) {
                    paths.addAll(this.scanDirectory(file));
                }
                ++n2;
            }
        }
        return paths;
    }

    public List<String> scanForHtmlFiles(File directory) {
        ArrayList<String> htmlFiles = new ArrayList<String>();
        if (!directory.isDirectory() || !directory.exists()) {
            return htmlFiles;
        }
        File[] files = directory.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile() && file.getName().toLowerCase().endsWith(".html")) {
                    htmlFiles.add(file.getAbsolutePath());
                } else if (file.isDirectory()) {
                    htmlFiles.addAll(this.scanForHtmlFiles(file));
                }
                ++n2;
            }
        }
        return htmlFiles;
    }

    public Set<String> getAllUniqueFileExtensions(File directory) {
        HashSet<String> extensions = new HashSet<String>();
        if (!directory.isDirectory()) {
            return extensions;
        }
        File[] files = directory.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile()) {
                    String fileName = file.getName();
                    int dotIndex = fileName.lastIndexOf(46);
                    if (dotIndex > 0 && dotIndex < fileName.length() - 1) {
                        extensions.add(fileName.substring(dotIndex + 1).toLowerCase());
                    }
                } else if (file.isDirectory()) {
                    extensions.addAll(this.getAllUniqueFileExtensions(file));
                }
                ++n2;
            }
        }
        return extensions;
    }

    public FileNode buildFileNodeTree(File directory) {
        FileNode rootNode = new FileNode(directory);
        File[] files = directory.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    rootNode.addChild(this.buildFileNodeTree(file));
                } else {
                    rootNode.addChild(new FileNode(file));
                }
                ++n2;
            }
        }
        return rootNode;
    }

    public void collectAbsolutePaths(FileNode node, List<String> paths) {
        paths.add(node.getAbsolutePath());
        for (FileNode child : node.getChildren()) {
            this.collectAbsolutePaths(child, paths);
        }
    }
}

